import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/route/route.dart';
import 'package:viserpay/data/model/invoice/invoice_list_response_model.dart';
import 'package:viserpay/data/services/api_service.dart';
import 'package:viserpay/view/components/dialog/app_dialog.dart';

import '../../../../../core/helper/date_converter.dart';
import '../../../../../core/helper/string_format_helper.dart';
import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_color.dart';
import '../../../../../core/utils/my_strings.dart';
import '../../../../../core/utils/style.dart';
import '../../../../../data/controller/invoice/invoice_history_controller.dart';
import '../../../../components/bottom-sheet/bottom_sheet_header_row.dart';
import '../../../../components/divider/custom_divider.dart';
import '../../../add-money/add_money_history/widget/status_widget.dart';
import 'invoice_action_button.dart';

class InvoicesBottomSheet {
  static void bottomSheet(BuildContext context, int index, {required InvoiceDataModel invoicesDataModel}) {
    showModalBottomSheet(
        isScrollControlled: true,
        backgroundColor: MyColor.transparentColor,
        context: context,
        builder: (context) => GetBuilder<InvoiceHistoryController>(
              builder: (controller) => ConstrainedBox(
                constraints: BoxConstraints(maxHeight: MediaQuery.of(context).size.height * 0.9),
                child: SingleChildScrollView(
                  child: Container(
                    // constraints: BoxConstraints(maxHeight: MediaQuery.of(context).size.height * 0.9),
                    padding: const EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space20),
                    width: MediaQuery.of(context).size.width,
                    decoration: BoxDecoration(color: MyColor.getCardBgColor(), borderRadius: const BorderRadius.vertical(top: Radius.circular(15))),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        const BottomSheetHeaderRow(
                          header: MyStrings.invoiceDetails,
                          bottomSpace: 0,
                        ),
                        const SizedBox(height: Dimensions.space20),

                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  MyStrings.invoicesNO.tr,
                                  style: regularSmall.copyWith(color: MyColor.getTextColor().withValues(alpha: 0.6)),
                                ),
                                const SizedBox(height: Dimensions.space5),
                                Text(
                                  invoicesDataModel.invoiceUid ?? "",
                                  style: regularDefault.copyWith(color: MyColor.getTextColor()),
                                )
                              ],
                            ),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.end,
                              children: [
                                Text(
                                  MyStrings.date.tr,
                                  style: regularSmall.copyWith(color: MyColor.getTextColor().withValues(alpha: 0.6)),
                                ),
                                const SizedBox(height: Dimensions.space5),
                                Text(
                                  DateConverter.isoStringToLocalDateOnly(invoicesDataModel.createdAt ?? ""),
                                  style: regularDefault.copyWith(color: MyColor.getTextColor()),
                                )
                              ],
                            )
                          ],
                        ),
                        const SizedBox(height: Dimensions.space15),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  MyStrings.paymentStatus.tr,
                                  style: regularSmall.copyWith(color: MyColor.getTextColor().withValues(alpha: 0.6)),
                                ),
                                const SizedBox(height: Dimensions.space5),
                                StatusWidget(
                                  status: controller.getStatusOrColor(index),
                                  color: controller.getStatusOrColor(index, isStatus: false),
                                )
                              ],
                            ),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.end,
                              children: [
                                Text(
                                  MyStrings.amount.tr,
                                  style: regularSmall.copyWith(color: MyColor.getTextColor().withValues(alpha: 0.6)),
                                ),
                                const SizedBox(height: Dimensions.space5),
                                Text(
                                  "${StringConverter.formatNumber(
                                    invoicesDataModel.totalAmount ?? "",
                                  )} ${Get.find<ApiClient>().getCurrencyOrUsername(isCurrency: true)}",
                                  style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                                )
                              ],
                            ),
                          ],
                        ),

                        const CustomDivider(space: Dimensions.space15),
                        Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Expanded(
                              child: Text(
                                MyStrings.productName.tr,
                                style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                              ),
                            ),
                            Expanded(
                              child: Text(
                                MyStrings.amount.tr,
                                textAlign: TextAlign.end,
                                style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                              ),
                            )
                          ],
                        ),
                        const SizedBox(
                          height: Dimensions.space10,
                        ),
                        ListView.builder(
                            physics: const NeverScrollableScrollPhysics(),
                            shrinkWrap: true,
                            itemCount: invoicesDataModel.invoiceItem?.length ?? 0,
                            itemBuilder: (context, index) {
                              var item = invoicesDataModel.invoiceItem?[index];
                              return Padding(
                                padding: const EdgeInsets.symmetric(vertical: 10),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                  children: [
                                    // Text(
                                    //   "#${index}",
                                    //   style: regularSmall.copyWith(color: MyColor.getTextColor().withValues(alpha:0.6)),
                                    // ),
                                    // SizedBox(
                                    //    width: Dimensions.space20,
                                    // ),
                                    Expanded(
                                      child: Text(
                                        item?.name ?? "",
                                        style: regularSmall.copyWith(color: MyColor.getTextColor().withValues(alpha: 0.6)),
                                      ),
                                    ),
                                    Expanded(
                                      child: Text(
                                        "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${StringConverter.formatNumber(item?.price ?? "0")}",
                                        textAlign: TextAlign.end,
                                        style: regularSmall.copyWith(color: MyColor.getTextColor().withValues(alpha: 0.6)),
                                      ),
                                    )
                                  ],
                                ),
                              );
                            }),

                        const SizedBox(
                          height: Dimensions.space10,
                        ),
                        // const CustomDivider(space: Dimensions.space15),
                        Container(
                          width: double.infinity,
                          padding: const EdgeInsets.symmetric(vertical: 8, horizontal: 3),
                          color: MyColor.getGreyText().withValues(alpha: 0.1),
                          child: Row(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Row(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Text(
                                    "${MyStrings.totalItem.tr} ",
                                    style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                                  ),
                                  Text(
                                    "${invoicesDataModel.totalItem}",
                                    style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                                  ),
                                ],
                              ),
                              Row(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Text(
                                    "${MyStrings.total.tr} ",
                                    style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                                  ),
                                  Text(
                                    "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${StringConverter.formatNumber(
                                      invoicesDataModel.totalAmount ?? "0",
                                    )}",
                                    style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                                  ),
                                ],
                              ),
                            ],
                          ),
                        ),
                        const SizedBox(
                          height: Dimensions.space10,
                        ),
                        Row(
                          children: [
                            //user can edit only unpublished invoice
                            if (invoicesDataModel.status == "0")
                              Expanded(
                                child: InVoiceActionButton(
                                  press: () {
                                    print(invoicesDataModel.toJson());
                                    // controller.getPaymentStatusOrColor(index);
                                    Get.toNamed(RouteHelper.invoicePaymentScreen, arguments: [invoicesDataModel]);
                                  },
                                  text: MyStrings.confirmPayment.tr,
                                  bgColor: MyColor.getPrimaryColor(),
                                  iconData: Icons.payments_rounded,
                                ),
                              ),
                            const SizedBox(
                              width: Dimensions.space10,
                            ),
                            if (invoicesDataModel.status == "0")
                              Expanded(
                                child: InVoiceActionButton(
                                  press: () {
                                    print(invoicesDataModel.toJson());

                                    AppDialog().invoiceRejectDialog(context, onPressYes: (v) {
                                      controller.rejectInvoice(v, invoicesDataModel.id.toString());
                                    });
                                  },
                                  text: MyStrings.reject.tr,
                                  bgColor: MyColor.redCancelTextColor,
                                  iconData: Icons.cancel_rounded,
                                ),
                              ),
                          ],
                        ),
                        const SizedBox(
                          height: Dimensions.space10,
                        ),
                        InVoiceActionButton(
                          press: () {
                            controller.downloadINVOICE(invoicesDataModel.id.toString());
                          },
                          text: controller.downloadLoading ? "${MyStrings.downloading.tr}..." : MyStrings.download.tr,
                          bgColor: MyColor.colorOrange,
                          iconData: Icons.download_for_offline_rounded,
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            ));
  }
}
